// Solace -- Sol Anachronistic Computer Emulation
// A Win32 emulator for the Sol-20 computer.
//
// Copyright (c) Jim Battle, 2000, 2001

// various type definitions used by Sol emulator

#ifndef _WINTAPE_H_
#define _WINTAPE_H_

#include <windows.h>

// called at startup
void WinTapeInit(HINSTANCE hInst, HWND mainwnd);

// called as a request to close up shop.
// returns 0 if OK, 1 if not OK.
int WinTapeClose(void);

// free resources when program exits
void WinTapeDestroy(void);

// create or restore a tape unit interface
void CreateTapeWindow(int unit);

// indicates if tape window is active or not
int TapeWindowVisible(int unit);

// get configuration from .ini file
void WinTapeLoadOptions(char *inifile);

// save configuration to .ini file
void WinTapeSaveOptions(char *inifile);

// callback to notify interface of changes
enum { WT_EOF=1,	// hit end of tape -- force stop
       WT_TIME=2,	// timestamp update, param=10ths of sec
       WT_PLAYSTATE=3,	// play, record, etc
       WT_FILESTATE=4,	// changed to empty or whatever
     };
void WinTapeNotify(int unit, int code, int param);

// return name of tape in drive
char *GetTapeFilename(int unit);

#endif // ifdef _WINTAPE_H_

